<?php 
namespace PaymentModule\PayPalApiV2;
use Frontend\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Base\File\FileHandle as FileHandle;
use Laminas\Db\Sql\Where;

class Common extends AbstractModule
{
	 var $paypalAccount;
	 var $mode;
	 var $form;
		  
	function __construct()
	{
		 require_once (dirname(__FILE__)."/config.php");
		 require_once (dirname(__FILE__)."/lib/Helpers/PayPalHelper.php");
		  $this->multipleCurrency = true;
	}
	
	function paymentIPN($GetArray,$PostArray=""){
		
		
		$dir = FileHandle::CheckPrivateLogDirectory("tmp");
		$dir = FileHandle::CheckPrivateLogDirectory("tmp/payment");
		$filename=$dir."PaymentPaypalAPIV2-webhook-".date("Y-m-d_h-i-s").".txt";
		$fp2 = fopen($filename, "w");
	
		$rawData = file_get_contents("php://input");
		fputs($fp2,"----------------POST Variable start---------\r\n");	
		fputs($fp2,"rawData=".print_r($rawData,true)."\r\n");	
		fputs($fp2,"----------------POST Variable end---------\r\n");
		
		fputs($fp2,"----------------POST Variable start---------\r\n");	
		fputs($fp2,"POST=".print_r($_POST,true)."\r\n");	
		fputs($fp2,"----------------POST Variable end---------\r\n");
		fclose($fp2);
		
		//$rawData_TEST = '{"id":"WH-0W241635U33613342-9GR2936822414121F","event_version":"1.0","create_time":"2023-11-24T06:21:52.946Z","resource_type":"capture","resource_version":"2.0","event_type":"PAYMENT.CAPTURE.COMPLETED","summary":"Payment completed for GBP 20.28 GBP","resource":{"amount":{"value":"20.28","currency_code":"GBP"},"seller_protection":{"dispute_categories":["ITEM_NOT_RECEIVED","UNAUTHORIZED_TRANSACTION"],"status":"ELIGIBLE"},"create_time":"2023-11-24T06:21:48Z","custom_id":"MTA3MTZAQEAyMC4yOA==","payee":{"email_address":"vaneet_business@webcreationuk.com","merchant_id":"4EGZ2UEC7NJV4"},"supplementary_data":{"related_ids":{"order_id":"3SJ179423Y323014H"}},"update_time":"2023-11-24T06:21:48Z","final_capture":true,"seller_receivable_breakdown":{"paypal_fee":{"value":"0.54","currency_code":"GBP"},"gross_amount":{"value":"20.28","currency_code":"GBP"},"net_amount":{"value":"19.74","currency_code":"GBP"}},"invoice_id":"INV-10716-16460","links":[{"method":"GET","rel":"self","href":"https://api.sandbox.paypal.com/v2/payments/captures/55K02150UR342004G"},{"method":"POST","rel":"refund","href":"https://api.sandbox.paypal.com/v2/payments/captures/55K02150UR342004G/refund"},{"method":"GET","rel":"up","href":"https://api.sandbox.paypal.com/v2/checkout/orders/3SJ179423Y323014H"}],"id":"55K02150UR342004G","status":"COMPLETED"},"links":[{"href":"https://api.sandbox.paypal.com/v1/notifications/webhooks-events/WH-0W241635U33613342-9GR2936822414121F","rel":"self","method":"GET"},{"href":"https://api.sandbox.paypal.com/v1/notifications/webhooks-events/WH-0W241635U33613342-9GR2936822414121F/resend","rel":"resend","method":"POST"}]}';
		
		if(isset($rawData) && $rawData != ""){
			
			$TmpData = json_decode($rawData);
			if( isset($TmpData->resource_type) && in_array(strtoupper($TmpData->resource_type),array("CAPTURE")) &&
				isset($TmpData->event_type) && in_array(strtoupper($TmpData->event_type),array("PAYMENT.CAPTURE.COMPLETED")) ){
				if(isset($TmpData->resource->status) && strtoupper($TmpData->resource->status) == "COMPLETED" &&
					isset($TmpData->resource->custom_id) && $TmpData->resource->custom_id != ""){
					$custom_array = explode("@@@",base64_decode($TmpData->resource->custom_id));
					if(isset($custom_array[0]) && $custom_array[0] != ""){
						$OrderID = $custom_array[0];
						$Obj =  $this->getClass('Sale\Cart\ShoppingCalculation')->getOrder($OrderID);		
						if(isset($Obj->PaymentStatus) && $Obj->PaymentStatus != "Paid"){
							
							$Return['OrderID'] = $Obj->OrderID;
							$Return['PaymentStatus'] = "Paid";
							$Return['Process'] = "1";
							$Return['Invoice'] = "1";
							$Return['ClearCart'] = "1";
							$this->getClass("Sale\Checkout\Common")->processPayment($Return['OrderID'],$Return,$_GET,$_POST);
							$this->getClass("Sale\Checkout\Common")->processInvoice($Return['OrderID'],$Return,$_GET,$_POST);
							$this->getClass("Sale\Checkout\Common")->clearCart($Return['OrderID']);
							
						}
					}
				}
			}
		}
		header("Content-Type: text/plain");
		echo "OK";exit;
		//https://sun82.elevateomdev.com/newsite/index.php?m=checkout&v=Payment&method=PayPalApiV2
		
		
	}
	
	function getPaymentPreProcess($Obj){
		/* nothing to do*/
		if(isset($_GET['APIAction']) && $_GET['APIAction']=="CreateOrder")
		{
			header('Content-Type: application/json');
			echo json_encode($this->CreatePayPalOrder($Obj));
			exit;
		}
		
		if(isset($_GET['APIAction']) && $_GET['APIAction']=="CaptureOrder")
		{
			header('Content-Type: application/json');
			echo json_encode($this->CapturePayPalOrder($Obj));
			exit;
		}
		
		if(isset($_GET['APIAction']) && $_GET['APIAction']=="AfterCapture")
		{
			$PayPalOrder = $this->GetPayPalOrder($Obj);
			if(isset($PayPalOrder['data']['purchase_units'][0]['payments']['captures'][0]['status']) && strtoupper($PayPalOrder['data']['purchase_units'][0]['payments']['captures'][0]['status']) == "COMPLETED"){
				
				$Return['OrderID'] = $Obj->OrderID;
				$Return['PaymentStatus'] = "Paid";
				$Return['Process'] = "1";
				$Return['Invoice'] = "1";
				$Return['ClearCart'] = "1";
				$this->getClass("Sale\Checkout\Common")->processPayment($Return['OrderID'],$Return,$_GET,$_POST);
				$this->getClass("Sale\Checkout\Common")->processInvoice($Return['OrderID'],$Return,$_GET,$_POST);
				$this->getClass("Sale\Checkout\Common")->clearCart($Return['OrderID']);
				MyRedirect(SKSEOURL('customer','Thankyou','','Status=Completed&PaymentEnd=1&OrderID='.$Return['OrderID']));
				exit;
				
			}
			else{
			
				$this->getSession()->setArrVar("alert",array("danger","Something went wrong please try again."));
				MyRedirect(SKSEOURL('checkout','Confirm'));
				exit;
			}
			
		}
	}
	
	function getPaymentPostProcess($Obj,$PostArray=""){
		if(isset($PostArray['Process']) && $PostArray['Process']=="1"){
			
		}
	}
	function getPaymentPreForm($Obj,$PostArray=""){
		
		
		$Currency = "GBP";
		$CurrencyObj = $this->getClass("Frontend\Common\Common")->getDefaultCurrency();
		if(isset($CurrencyObj->Code) && strlen($CurrencyObj->Code)==3)
			$Currency = $CurrencyObj->Code;
		
		
		$GLOBALS['InnerJsFile'][] = array('https://www.paypal.com/sdk/js?client-id='.PAYPAL_CREDENTIALS[PAYPAL_ENVIRONMENT]['client_id'].'&currency='.$Currency.'&intent=capture',true);
			$GLOBALS['InnerJsScript'][] = "
				<script type='text/javascript'>
						paypal.Buttons({

							// Set your environment
							env: '".d("DEFINE_SK_PAYMENT_PAYPAL_APIV2_MODE")."',

							// Set style of button
							style: {
								layout: 'vertical',   // horizontal | vertical
								size:   'responsive',    // medium | large | responsive
								shape:  'pill',      // pill | rect
								color:  'gold'       // gold | blue | silver | black
							},

							// Execute payment on authorize
							commit: true,

							// Wait for the PayPal button to be clicked
							createOrder: function() {
								return fetch('".SKSEOURL('checkout','Confirm','','APIAction=CreateOrder')."')
								.then(function(response) {
									return response.json();
								}).then(function(resJson) {
									console.log(resJson)
									console.log(resJson.data.id)
									return resJson.data.id;
								});
								
							},

							// Wait for the payment to be authorized by the customer
							onApprove: function(data, actions) {
								// Capture Order
									let postData = new FormData();
									return fetch(
										'".SKSEOURL('checkout','Confirm','','APIAction=CaptureOrder')."',
										{
											method: 'POST',
											body: postData
										}
									).then(function(res) {
										return res.json();
									}).then(function() {
										window.location.href = '".SKSEOURL('checkout','Confirm','','APIAction=AfterCapture')."';
									});
								
							}

						}).render('#paypalCheckoutContainer');

					</script>";

		
		$Return = '<div class="text-center m-auto w-50"><div id="paypalCheckoutContainer"></div></div>
		<form class="d-none" role="form" method="POST" class="my-3" action="'.SKSEOURL('checkout','Confirm').'">';
		$Return .= '<input type="hidden" name="Process" value="1" />';
		
		
		return $Return;
	}
	
	function getPaymentPostForm($PostArray=""){
		
		$Return = '
		
		';
		//$Return .= '<table border="0" cellpadding="10" cellspacing="0" align="center"><tr><td align="center"></td></tr><tr><td align="center"><a href="#" onclick="javascript:window.open(\'https://www.paypal.com/cgi-bin/webscr?cmd=xpt/Marketing/popup/OLCWhatIsPayPal-outside\',\'olcwhatispaypal\',\'toolbar=no, location=no, directories=no, status=no, menubar=no, scrollbars=yes, resizable=yes, width=400, height=350\');"><img  src="https://www.paypal.com/en_US/i/bnr/bnr_paymentsBy_150x40.gif" border="0" alt="PayPal Logo"></a></td></tr></table>';
		$Return .= '</form>';
		return $Return;
	}
	
	function getMethod($PostArray="")
	{
			
		$ResponseArray = array();
		$ResponseArray = array("title"=>"Paypal API",
								"note"=>"fdsfdsf",
								"hidenote"=>"fdsfs",
							  );

		return $ResponseArray; 
  
    }

	function CreatePayPalOrder($Obj,$PostArray="")
	{
		$paypalHelper = new \PayPalHelper;
		$Amount = str_replace(",","",number_format($Obj->GrandTotal,2));
		$Custom = base64_encode((int)$Obj->OrderID.'@@@'.$Amount);
		$Currency = "GBP";
		$CurrencyObj = $this->getClass("Frontend\Common\Common")->getDefaultCurrency();
		if(isset($CurrencyObj->Code) && strlen($CurrencyObj->Code)==3)
			$Currency = $CurrencyObj->Code;
			
		$randNo= (string)rand(10000,20000);
		
		$Amount = str_replace(",","",number_format($Obj->GrandTotal,2));
		$Custom = base64_encode((int)$Obj->OrderID.'@@@'.$Amount);
			
			
		$OrderData = array();
		$OrderData['intent'] = 'CAPTURE'; //CAPTURE,AUTHORIZE
		$OrderData['application_context']['return_url'] = ""; //SKSEOURL('customer','Thankyou','','Status=Completed&PaymentEnd=1&OrderID='.$Obj->OrderID);
		$OrderData['application_context']['cancel_url'] = ""; //SKSEOURL('checkout','Confirm');
		$OrderData['purchase_units'][0]['reference_id'] = isset($Obj->OrderNo)?$Obj->OrderNo:"";
		$OrderData['purchase_units'][0]['description'] = "Shop";//d("SITE_NAME").' Shop';
		$OrderData['purchase_units'][0]['custom_id'] = $Custom;
		$OrderData['purchase_units'][0]['invoice_id'] = 'INV-'.$Obj->OrderID.'-'.$randNo;
		//$OrderData['purchase_units'][0]['soft_descriptor'] = substr(d("SITE_NAME"),0,21);
		$OrderData['purchase_units'][0]['soft_descriptor'] = "PayPal Payment";
		
		$cartRows = $this->getClass("Sale\Cart\Common")->getOrderCart($Obj->OrderID);
		
		$i =0;
		foreach($cartRows as $CurrentCartItem){
			$ItemName = preg_replace('/[^a-zA-Z0-9- _\.]/','', $CurrentCartItem->ItemName); 
			$OrderData['purchase_units'][0]['items'][$i]['name'] = substr($ItemName,0,125);
			$OrderData['purchase_units'][0]['items'][$i]['description'] = substr($ItemName,0,125);
			$OrderData['purchase_units'][0]['items'][$i]['sku'] = $CurrentCartItem->ItemNo;
			$OrderData['purchase_units'][0]['items'][$i]['quantity'] = $CurrentCartItem->Qty;
			//$OrderData['purchase_units'][0]['items'][$i]['category'] = $category;
			$OrderData['purchase_units'][0]['items'][$i]['unit_amount']['currency_code'] = $Currency;
			$OrderData['purchase_units'][0]['items'][$i]['unit_amount']['value'] = str_replace(",","",number_format($CurrentCartItem->Price,2));
			//$OrderData['purchase_units'][0]['items'][$i]['tax']['currency_code'] = $Currency;
			//$OrderData['purchase_units'][0]['items'][$i]['tax']['value'] = str_replace(",","",number_format($CurrentCartItem->TaxPrice,2));
			$i++;
	}
		
		
		$OrderData['purchase_units'][0]['amount']['currency_code'] = $Currency;
		$OrderData['purchase_units'][0]['amount']['value'] = $Amount;
		
		$OrderData['purchase_units'][0]['amount']['breakdown']['item_total']['currency_code'] = $Currency;
		$OrderData['purchase_units'][0]['amount']['breakdown']['item_total']['value'] = str_replace(",","",number_format($Obj->SubTotal,2));
		$OrderData['purchase_units'][0]['amount']['breakdown']['shipping']['currency_code'] = $Currency;
		$OrderData['purchase_units'][0]['amount']['breakdown']['shipping']['value'] = str_replace(",","",number_format($Obj->ShippingAmount,2));
		$OrderData['purchase_units'][0]['amount']['breakdown']['tax_total']['currency_code'] = $Currency;
		$OrderData['purchase_units'][0]['amount']['breakdown']['tax_total']['value'] = str_replace(",","",number_format($Obj->TaxAmount,2));
		if($Obj->ProductDiscount > 0){
			$OrderData['purchase_units'][0]['amount']['breakdown']['discount']['currency_code'] = $Currency;
			$OrderData['purchase_units'][0]['amount']['breakdown']['discount']['value'] = str_replace(",","",number_format($Obj->ProductDiscount,2));
		}
		
		//$OrderData['purchase_units'][0]['amount']['breakdown']['handling']['currency_code'] = $Currency;
		//$OrderData['purchase_units'][0]['amount']['breakdown']['handling']['value'] = str_replace(",","",number_format($Obj->SubTotal,2));
		//$OrderData['purchase_units'][0]['amount']['breakdown']['insurance']['currency_code'] = $Currency;
		//$OrderData['purchase_units'][0]['amount']['breakdown']['insurance']['value'] = str_replace(",","",number_format($Obj->SubTotal,2));
		
		
		
		
		$OrderData['application_context']['shipping_preference'] = "SET_PROVIDED_ADDRESS";
		$OrderData['application_context']['user_action'] = "PAY_NOW";
		
		$OrderData['purchase_units'][0]['shipping']['type']= "SHIPPING";
		//$OrderData['purchase_units'][0]['shipping']['name']['given_name']= isset($Obj->ShippingFirstName)?$Obj->ShippingFirstName:"";
		//$OrderData['purchase_units'][0]['shipping']['name']['surname']= isset($Obj->ShippingLastName)?$Obj->ShippingLastName:"";
		$OrderData['purchase_units'][0]['shipping']['name']['full_name']= (isset($Obj->ShippingFirstName)?$Obj->ShippingFirstName:"")." ".(isset($Obj->ShippingLastName)?$Obj->ShippingLastName:"");
		$OrderData['purchase_units'][0]['shipping']['address']['address_line_1']= isset($Obj->ShippingAddress1)?$Obj->ShippingAddress1:"";
		$OrderData['purchase_units'][0]['shipping']['address']['address_line_2']= isset($Obj->ShippingAddress2)?$Obj->ShippingAddress2:"";
		$OrderData['purchase_units'][0]['shipping']['address']['admin_area_2']= isset($Obj->ShippingCity)?$Obj->ShippingCity:"";
		$OrderData['purchase_units'][0]['shipping']['address']['admin_area_1']= isset($Obj->ShippingState)?$Obj->ShippingState:"";
		$OrderData['purchase_units'][0]['shipping']['address']['postal_code']= isset($Obj->ShippingZipCode)?$Obj->ShippingZipCode:"";
		$OrderData['purchase_units'][0]['shipping']['address']['country_code']= isset($Obj->ShippingCountry)?$Obj->ShippingCountry:"GB";

		$OrderData['payer']['email_address']= (isset($Obj->Email)?$Obj->Email:"");
		$OrderData['payer']['full_name']= (isset($Obj->BillingFirstName)?$Obj->BillingFirstName:"")." ".(isset($Obj->BillingLastName)?$Obj->BillingLastName:"");
		$OrderData['payer']['name']['given_name']= isset($Obj->BillingFirstName)?$Obj->BillingFirstName:"";
		$OrderData['payer']['name']['surname']= isset($Obj->BillingLastName)?$Obj->BillingLastName:"";
		$OrderData['payer']['address']['address_line_1']= isset($Obj->BillingAddress1)?$Obj->BillingAddress1:"";
		$OrderData['payer']['address']['address_line_2']= isset($Obj->BillingAddress2)?$Obj->BillingAddress2:"";
		$OrderData['payer']['address']['admin_area_2']= isset($Obj->BillingCity)?$Obj->BillingCity:"";
		$OrderData['payer']['address']['admin_area_1']= isset($Obj->BillingState)?$Obj->BillingState:"";
		$OrderData['payer']['address']['postal_code']= isset($Obj->BillingZipCode)?$Obj->BillingZipCode:"";
		$OrderData['payer']['address']['country_code']= isset($Obj->BillingCountry)?$Obj->BillingCountry:"GB";
		
		//$OrderData['payer']['phone']['phone_type']= "MOBILE";
		//$OrderData['payer']['phone']['phone_number']['national_number']= isset($Obj->BillingPhone)?$Obj->BillingPhone:"";
		

		/*
		$OrderData['payment_source']['paypal']['email_address']= (isset($Obj->Email)?$Obj->Email:"");
		$OrderData['payment_source']['paypal']['name']= (isset($Obj->BillingFirstName)?$Obj->BillingFirstName:"")." ".(isset($Obj->BillingLastName)?$Obj->BillingLastName:"");
		//$OrderData['payment_source']['paypal']['name']['given_name']= isset($Obj->BillingFirstName)?$Obj->BillingFirstName:"";
		//$OrderData['payment_source']['paypal']['name']['surname']= isset($Obj->BillingLastName)?$Obj->BillingLastName:"";
		$OrderData['payment_source']['paypal']['billing_address']['address']['address_line_1']= isset($Obj->BillingAddress1)?$Obj->BillingAddress1:"";
		$OrderData['payment_source']['paypal']['billing_address']['address']['address_line_2']= isset($Obj->BillingAddress2)?$Obj->BillingAddress2:"";
		$OrderData['payment_source']['paypal']['billing_address']['address']['admin_area_2']= isset($Obj->BillingCity)?$Obj->BillingCity:"";
		$OrderData['payment_source']['paypal']['billing_address']['address']['admin_area_1']= isset($Obj->BillingState)?$Obj->BillingState:"";
		$OrderData['payment_source']['paypal']['billing_address']['address']['postal_code']= isset($Obj->BillingZipCode)?$Obj->BillingZipCode:"";
		$OrderData['payment_source']['paypal']['billing_address']['address']['country_code']= isset($Obj->BillingCountry)?$Obj->BillingCountry:"GB";

		$OrderData['payment_source']['card']['name']= (isset($Obj->BillingFirstName)?$Obj->BillingFirstName:"")." ".(isset($Obj->BillingLastName)?$Obj->BillingLastName:"");
		$OrderData['payment_source']['card']['billing_address']['address']['address_line_1']= isset($Obj->BillingAddress1)?$Obj->BillingAddress1:"";
		$OrderData['payment_source']['card']['billing_address']['address']['address_line_2']= isset($Obj->BillingAddress2)?$Obj->BillingAddress2:"";
		$OrderData['payment_source']['card']['billing_address']['address']['admin_area_2']= isset($Obj->BillingCity)?$Obj->BillingCity:"";
		$OrderData['payment_source']['card']['billing_address']['address']['admin_area_1']= isset($Obj->BillingState)?$Obj->BillingState:"";
		$OrderData['payment_source']['card']['billing_address']['address']['postal_code']= isset($Obj->BillingZipCode)?$Obj->BillingZipCode:"";
		$OrderData['payment_source']['card']['billing_address']['address']['country_code']= isset($Obj->BillingCountry)?$Obj->BillingCountry:"GB";
		*/

		$OrderDataJson = json_encode($OrderData);
		$ReturnJson = $paypalHelper->orderCreate($OrderDataJson);
		
		if(isset($ReturnJson['data']['id']) && $ReturnJson['data']['id'] != ""){
			$OrderObj = new DataTable(TABLE_ORDERS);
			$OrderObj->where[] = array('=',array('OrderID' => $Obj->OrderID));
			$DataArray = array();
			$DataArray['TransactionID'] = isset($ReturnJson['data']['id'])?$ReturnJson['data']['id']:"";;
			$OrderObj->tableUpdate($DataArray);
		}
		//$ReturnJson = $OrderDataJson;
		return $ReturnJson;
	
	}
	
	function CapturePayPalOrder($Obj,$PostArray="")
	{
		$paypalHelper = new \PayPalHelper;
		$ReturnJson = $paypalHelper->orderCapture($Obj->TransactionID);
		
		$dir = FileHandle::CheckPrivateLogDirectory("tmp");
		$dir = FileHandle::CheckPrivateLogDirectory("tmp/payment");
		$filename=$dir."PaymentPaypalAPIV2-".$Obj->OrderID."-".date("Y-m-d_h-i-s").".txt";
		$fp2 = fopen($filename, "w");
		
		fputs($fp2,"----------------TransactionID Variable start---------\r\n");	
		fputs($fp2,"TransactionID=".$Obj->TransactionID."\r\n");	
		fputs($fp2,"----------------TransactionID Variable end---------\r\n");
		
		fputs($fp2,"----------------ReturnJson Variable start---------\r\n");	
		fputs($fp2,"ReturnJson=".print_r($ReturnJson,true)."\r\n");	
		fputs($fp2,"----------------ReturnJson Variable end---------\r\n");
		
		fputs($fp2,"----------------POST Variable start---------\r\n");	
		fputs($fp2,"POST=".print_r($_POST,true)."\r\n");	
		fputs($fp2,"----------------POST Variable end---------\r\n");
		fclose($fp2);
		
		/* ORDER change status insert start*/
			$OrderLogObj = new DataTable(TABLE_ORDER_LOG);
			$DataArray = array();
			$DataArray['OrderID'] = $Obj->OrderID;
			$DataArray['MSG'] = "PayPalApiV2Capture";
			$DataArray['MSGOBJ'] = print_r($ReturnJson,true);
			$DataArray['LogInfo'] = base64_encode(serialize($ReturnJson));
			$DataArray['CreatedDate'] = date("Y-m-d H:i:s");
			$OrderLogObj->tableInsert($DataArray);
			/* ORDER change status insert end*/	
		
		return $ReturnJson;
	}
	function GetPayPalOrder($Obj,$PostArray="")
	{
		$paypalHelper = new \PayPalHelper;
		$ReturnJson = $paypalHelper->orderGet($Obj->TransactionID);
		return $ReturnJson;
	}
	
	function PatchPayPalOrder($Obj,$PostArray="")
	{
		
		
	}
	
}	